var ctx;

function drawPizza() {
	ctx = document.getElementById("pizzaCanvas").getContext("2d");
	ctx.save();
	ctx.translate(200, 200);

	drawCrust();
	drawSauce();
	drawCheese();
	drawToppings(16, drawMushroom);
	drawToppings(16, drawPepperoni);
	drawToppings(32, drawGreenPepper);

	ctx.restore();
}

function drawCrust() {
	ctx.fillStyle = "rgba(230, 192, 117, 1)";
	ctx.beginPath();
	ctx.arc(0, 0, 200, 0, 2 * Math.PI, false);
	ctx.fill();
}

function drawSauce() {
	ctx.fillStyle = "rgba(200, 55, 62, 1)";
	ctx.beginPath();
	ctx.arc(0, 0, 180, 0, 2 * Math.PI, false);
	ctx.fill();
}

function drawCheese() {
	ctx.fillStyle = "rgba(251, 246, 242, 1)";
	ctx.beginPath();
	ctx.arc(0, 0, 170, 0, 2 * Math.PI, false);
	ctx.fill();
}

function drawToppings(n, drawTopping) {
	ctx.save();
	ctx.rotate(2 * Math.random() * Math.PI);

	for (var i = 0; i < n; i++) {
		ctx.save();
		ctx.translate(0, 70 * (Math.sqrt(Math.random()) + i % 2) + 10);
		drawTopping();
		ctx.restore();
		ctx.rotate(2 * Math.PI / n);
	}

	ctx.restore();
}

function drawPepperoni() {
	ctx.fillStyle = "rgba(162, 53, 58, 1)";
	ctx.beginPath();
	ctx.arc(0, 0, 20, 0, 2 * Math.PI, false);
	ctx.fill();
}

function drawGreenPepper() {
	ctx.save();
	ctx.rotate(2 * Math.random() * Math.PI);
	ctx.fillStyle = "rgba(139, 195, 60, 1)";
	ctx.fillRect(-6, -6, 12, 12);
	ctx.restore();
}

function drawMushroom() {
	ctx.save();
	ctx.rotate(2 * Math.random() * Math.PI);
	ctx.translate(0, 10);
	ctx.fillStyle = "rgba(133, 114, 84, 1)";

	ctx.beginPath();
	ctx.arc(0, 0, 30, 1.25 * Math.PI, 1.75 * Math.PI, false);
	ctx.lineTo(20, -10);
	ctx.lineTo(8, -10);
	ctx.lineTo(11, 10);
	ctx.lineTo(-11, 10);
	ctx.lineTo(-8, -10);
	ctx.lineTo(-20, -10);
	ctx.closePath();
	ctx.fill();

	ctx.rotate(-0.25 * Math.PI);
	ctx.beginPath();
	ctx.arc(0, -20, 10, 0, 2 * Math.PI, false);
	ctx.fill();

	ctx.rotate(0.5 * Math.PI);
	ctx.beginPath();
	ctx.arc(0, -20, 10, 0, 2 * Math.PI, false);
	ctx.fill();
	ctx.restore();
}