var ctx;

function drawPizza() {
	ctx = document.getElementById("pizzaCanvas").getContext("2d");

	ctx.save();
	ctx.translate(200, 200);
	ctx.beginPath();
	ctx.arc(0, 0, 200, 0, 2 * Math.PI, false);
	ctx.clip();

	drawCrust();
	drawSauce();
	drawToppings(256, 4, 196, drawHerb);
	drawCrustCaramelization();
	drawToppings(4, 50, 50, drawCheese);
	drawToppings(8, 120, 120, drawCheese);
	drawToppings(16, 10, 150, drawMushroom);
	drawToppings(16, 10, 150, drawPepperoni);
	drawToppings(16, 10, 150, drawGreenPepper);

	ctx.restore();
}

function drawCrust() {
	var crustGradient = ctx.createRadialGradient(0, 0, 180, 0, 0, 200);

	crustGradient.addColorStop(0, "rgba(230, 192, 117, 1)");
	crustGradient.addColorStop(1, "rgba(233, 157, 73, 1)");

	ctx.fillStyle = crustGradient;
	ctx.beginPath();
	ctx.arc(0, 0, 200, 0, 2 * Math.PI, false);
	ctx.fill();
}

function drawCrustCaramelization() {
	var i, y, r, s;
	var crustGradient = ctx.createRadialGradient(0, 0, 180, 0, 0, 200);

	crustGradient.addColorStop(0, "rgba(230, 192, 117, 1)");
	crustGradient.addColorStop(1, "rgba(233, 157, 73, 1)");

	ctx.save();
	ctx.fillStyle = crustGradient;
	for (i = 0; i < 16; i++) {
		ctx.rotate(0.125 * Math.PI);
		ctx.beginPath();
		r = 40 + 60 * Math.random();
		y = 170 + r;
		ctx.arc(0, y, r, 0, 2 * Math.PI, false);
		ctx.fill();
	}
	ctx.restore();

	i = 0;
	while (i < 2 * Math.PI) {
		ctx.save();
		i = i + 0.05 * Math.random();
		ctx.rotate(i);
		ctx.translate(0, 182 + 16 * Math.random());
		s = 0.2 + 0.8 * Math.random();
		ctx.scale(s, s);
		drawCaramelization();
		ctx.restore();
	}
}

function drawCaramelization() {
	var caramelColor = "rgba(217, 102, 35";
	var caramelizationGradient = ctx.createRadialGradient(0, 0, 0, 0, 0, 6);

	caramelizationGradient.addColorStop(0, caramelColor + ", 1)");
	caramelizationGradient.addColorStop(1, caramelColor + ", 0)");

	ctx.fillStyle = caramelizationGradient;
	ctx.beginPath()
	ctx.arc(0, 0, 6, 0, 2 * Math.PI, false);
	ctx.fill();
}

function drawSauce() {
	ctx.fillStyle = "rgba(200, 55, 62, 1)";
	ctx.beginPath();
	ctx.arc(0, 0, 180, 0, 2 * Math.PI, false);
	ctx.fill();
}

function drawHerb() {
	ctx.save();
	ctx.rotate(2 * Math.random() * Math.PI);
	ctx.fillStyle = "rgba(0, 102, 0, 1)";
	ctx.fillRect(-2, -1, 4, 2);
	ctx.restore();
}

function drawCheese() {
	ctx.fillStyle = "rgba(246, 246, 232, 0.95)";
	ctx.beginPath();
	ctx.arc(0, 0, 40 + 10 * Math.random(), 0, 2 * Math.PI, false);
	ctx.fill();
}

function drawToppings(n, rMin, rMax, drawTopping) {
	ctx.save();
	ctx.rotate(2 * Math.random() * Math.PI);

	for (var i = 0; i < n; i++) {
		ctx.save();
		ctx.translate(0, 0.5 * (rMax - rMin) * (Math.sqrt(Math.random()) + i % 2) + rMin);
		drawTopping();
		ctx.restore();
		ctx.rotate(2 * Math.PI / n);
	}

	ctx.restore();
}

function drawPepperoni() {
	ctx.save();
	ctx.fillStyle = "rgba(162, 53, 58, 1)";
	ctx.beginPath();
	ctx.arc(0, 0, 20, 0, 2 * Math.PI, false);
	ctx.fill();

	drawToppings(16, 1, 15, drawFat);
	ctx.restore();
}

function drawFat() {
	ctx.fillStyle = "rgba(255, 255, 255, " + 0.5 * Math.random() + ")";
	ctx.beginPath();
	ctx.arc(0, 0, 1 + 1 * Math.random(), 0, 2 * Math.PI, false);
	ctx.fill();
}

function drawGreenPepper() {
	var r1 = 14 + 6 * Math.random();
	var r2 = 14 + 6 * Math.random();
	var length = 40 + 20 * Math.random();

	ctx.save();
	ctx.rotate(2 * Math.random() * Math.PI);
	ctx.lineWidth = 6;
	ctx.strokeStyle = "rgba(109, 155, 40, 1)";

	ctx.beginPath();
	ctx.arc(r1 -  length / 2, -1 + r1 / 2, r1, -Math.PI, -0.5 * Math.PI, false);
	ctx.arc(length / 2 - r2, -1 + r2 / 2, r2, -0.5 * Math.PI, 0, false);
	ctx.stroke();

	ctx.strokeStyle = "rgba(139, 195, 60, 1)";
	ctx.beginPath();
	ctx.arc(r1 -  length / 2, 1 + r1 / 2, r1, -Math.PI, -0.5 * Math.PI, false);
	ctx.arc(length / 2 - r2, 1 + r2 / 2, r2, -0.5 * Math.PI, 0, false);
	ctx.stroke();

	ctx.restore();
}

function drawMushroom() {
	var mushroomGradient;
	var y = 8 + 12 * Math.random();
	var s = 0.8 + 0.2 * Math.random();

	ctx.save();
	ctx.rotate(2 * Math.random() * Math.PI);
	ctx.translate(0, 10);
	ctx.scale(s, s);

	ctx.fillStyle = "rgba(211, 169, 101, 1)";

	ctx.beginPath();
	ctx.arc(0, 0, 30, 1.25 * Math.PI, 1.75 * Math.PI, false);
	ctx.lineTo(20, -10);
	ctx.lineTo(8, -10);
	ctx.lineTo(8 + 0.1 * y, -10 + y);
	ctx.lineTo(-(8 + 0.1 * y), -10 + y);
	ctx.lineTo(-8, -10);
	ctx.lineTo(-20, -10);
	ctx.closePath();
	ctx.fill();

	ctx.save();
	ctx.rotate(-0.25 * Math.PI);
	ctx.beginPath();
	ctx.arc(0, -20, 10, 0, 2 * Math.PI, false);
	ctx.fill();

	ctx.rotate(0.5 * Math.PI);
	ctx.beginPath();
	ctx.arc(0, -20, 10, 0, 2 * Math.PI, false);
	ctx.fill();
	ctx.restore();

	mushroomGradient = ctx.createRadialGradient(-10, -9, 3, -10, -11, 6);
	mushroomGradient.addColorStop(0, "rgba(107, 93, 67, 1)");
	mushroomGradient.addColorStop(1, "rgba(211, 169, 101, 1)");

	ctx.fillStyle = mushroomGradient;
	ctx.beginPath();
	ctx.arc(-10, -11, 6, 0.4 * Math.PI, 1.65 * Math.PI, false);
	ctx.fill();

	mushroomGradient = ctx.createRadialGradient(10, -9, 3, 10, -11, 6);
	mushroomGradient.addColorStop(0, "rgba(107, 93, 67, 1)");
	mushroomGradient.addColorStop(1, "rgba(211, 169, 101, 1)");

	ctx.fillStyle = mushroomGradient;
	ctx.beginPath();
	ctx.arc(10, -11, 6, -0.65 * Math.PI, 0.6 * Math.PI, false);
	ctx.fill();

	ctx.restore();
}